
#include "spi.h"



// This function configures the low level SPI interface
// to the nRF8001, both pins and module itself.
// SCLK, MOSI and MISO pin are standard SPI pins.
// REQN is an output to tell the nRF8001 we want to
// transmit data. RDYN is an input and informs us
// that the nRF8001 slave is ready to receive
// data
void configureNRF8001Interface()
{
	// Pin Configuration, see page 49 of MSP430 datasheet

	// Configure SCLK for USCI B0 peripheral module operation.
	nRF8001_SCLK_PSEL |= nRF8001_SCLK_PIN;
	nRF8001_SCLK_PSEL2 |= nRF8001_SCLK_PIN;

	// Configure MISO for USCI B0 peripheral module operation.
	nRF8001_MISO_PSEL  |= nRF8001_MISO_PIN;
	nRF8001_MISO_PSEL2 |= nRF8001_MISO_PIN;

	// Configure MOSI for USCI B0 peripheral module operation.
	nRF8001_MOSI_PSEL  |= nRF8001_MOSI_PIN;
	nRF8001_MOSI_PSEL2 |= nRF8001_MOSI_PIN;

	// Configure RDYN as input GPIO with interrupt on
	// high to low edge
	nRF8001_RDYN_PSEL  &= ~nRF8001_RDYN_PIN;
	nRF8001_RDYN_PSEL2 &= ~nRF8001_RDYN_PIN;
	nRF8001_RDYN_PDIR  &= ~nRF8001_RDYN_PIN;
	nRF8001_RDYN_PIES  |= nRF8001_RDYN_PIN;
	nRF8001_RDYN_PIFG  &= ~nRF8001_RDYN_PIN;
	nRF8001_RDYN_PIE   |= nRF8001_RDYN_PIN;

	// Configure REQN_CSN for USCI B0 as GPIO output, active low,
	// so default is high
	nRF8001_REQN_CSN_POUT  |= nRF8001_REQN_CSN_PIN;
	nRF8001_REQN_CSN_PSEL  &= ~nRF8001_REQN_CSN_PIN;
	nRF8001_REQN_CSN_PSEL2 &= ~nRF8001_REQN_CSN_PIN;
	nRF8001_REQN_CSN_PDIR  |= nRF8001_REQN_CSN_PIN;

	// Configure SPI module for 3-pin, 8-bit with LSB first
	// See page 22 of nRF8001
	SPI_CTL1 = UCSWRST;                   // Place module in reset
	SPI_CTL0 = 0;
	SPI_CTL0 |= UCCKPH + UCMST + UCSYNC;  // 3-pin, 8-bit SPI master using LSB first
	SPI_CTL1 |= UCSSEL_2;                 // Source from SMCLK
	SPI_BR0 = 8;                          // SMCLK/8 - 2MHz since nRF8001 SCK max is 3MHz
	SPI_BR1 = 0;
	SPI_CTL1 &= ~UCSWRST;                 // release module from reset

	// Enable SPI RX Interrupt for UCB0
	UCA1IE |= UCRXIE;
}
